#include <iostream>
#include <vector>
#include <algorithm>
#include <stack>
using namespace std;

typedef long long ll;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    
    int n;
    cin >> n;
    
    vector<pair<ll, ll>> v(n);
    for (int i = 0; i < n; i++) cin >> v[i].first;
    for (int i = 0; i < n; i++) cin >> v[i].second;
    
    sort(v.begin(), v.end());
    
    vector<ll> x(n), h(n);
    for (int i = 0; i < n; i++) {
        x[i] = v[i].first;
        h[i] = v[i].second;
    }
    
    vector<ll> L(n, 0), R(n, 0);

    stack<int> s;
    for (int i = 0; i < n; i++) {
        while (!s.empty()) {
            int j = s.top();
            ll dx = x[i] - x[j];
            ll need = h[i] - dx;
            if (need <= h[j]) {
                L[i] = max(L[i], h[j] + dx);
                break;
            }
            s.pop();
        }
        if (s.empty()) L[i] = h[i];
        s.push(i);
    }
 
    while (!s.empty()) s.pop();
    for (int i = n - 1; i >= 0; i--) {
        while (!s.empty()) {
            int j = s.top();
            ll dx = x[j] - x[i];
            ll need = h[i] - dx;
            if (need <= h[j]) {
                R[i] = max(R[i], h[j] + dx);
                break;
            }
            s.pop();
        }
        if (s.empty()) R[i] = h[i];
        s.push(i);
    }
    
    vector<ll> ans(n, -1);
    for (int i = 0; i < n; i++) {
        ll best = max(L[i], R[i]);
        if (best >= h[i]) {
            ans[i] = best - h[i];
        }
    }

    vector<pair<ll, int>> orig(n);
    for (int i = 0; i < n; i++) {
        orig[i] = {v[i].first, i};
    }
    sort(orig.begin(), orig.end());
    
    vector<ll> final_ans(n);
    for (int i = 0; i < n; i++) {
        final_ans[i] = ans[orig[i].second];
    }
    
    for (int i = 0; i < n; i++) {
        cout << final_ans[i] << "\n";
    }
    
    return 0;
}